﻿using System;

namespace HIPS.Web.UI.Helpers.Mapping.Context
{

    /// <summary>
    /// Provides context used when mapping hospitals.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="18 February 2014">Initial version.</change>
    /// </history>
    public class HospitalMappingContext
    {

        #region Properties

        /// <summary>
        /// Gets or sets the hospital code system to be used during mapping.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 February 2014">Initial version.</change>
        /// </history>
        public string HospitalCodeSystem { get; set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="hospitalCodeSystem">Hospital code system to be used during mapping.</param>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 February 2014">Initial version.</change>
        /// </history>
        public HospitalMappingContext(string hospitalCodeSystem)
        {
            this.HospitalCodeSystem = hospitalCodeSystem;
        }

        #endregion

    }
}